var GlWrapper = Java.type("com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper");

Java.asJSONCompatible({
    animation: function (maid, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, modelMap) {
        head = modelMap.get("head");
        wingLeft = modelMap.get("wingLeft");
        wingRight = modelMap.get("wingRight");
        blink = modelMap.get("blink");
        tail = modelMap.get("tail");
        sinFloat = modelMap.get("sinFloat");
        cosFloat = modelMap.get("cosFloat");
        negativeSinFloat = modelMap.get("-sinFloat");
        negativeCosFloat = modelMap.get("-cosFloat");
        negativeSinFloat2 = modelMap.get("_sinFloat");
        negativeCosFloat2 = modelMap.get("_cosFloat");
        helmet = modelMap.get("helmet");
        chestPlate = modelMap.get("chestPlate");
        chestPlateLeft = modelMap.get("chestPlateLeft");
        chestPlateMiddle = modelMap.get("chestPlateMiddle");
        chestPlateRight = modelMap.get("chestPlateRight");
        leggings = modelMap.get("leggings");
        leggingsLeft = modelMap.get("leggingsLeft");
        leggingsMiddle = modelMap.get("leggingsMiddle");
        leggingsRight = modelMap.get("leggingsRight");
        bootsLeft = modelMap.get("bootsLeft");
        bootsRight = modelMap.get("bootsRight");
        // 反向隐藏护甲
        reverseHelmet = modelMap.get("-helmet");
        reverseChestPlate = modelMap.get("-chestPlate");
        reverseChestPlateLeft = modelMap.get("-chestPlateLeft");
        reverseChestPlateMiddle = modelMap.get("-chestPlateMiddle");
        reverseChestPlateRight = modelMap.get("-chestPlateRight");
        reverseLeggings = modelMap.get("-leggings");
        reverseLeggingsLeft = modelMap.get("-leggingsLeft");
        reverseLeggingsMiddle = modelMap.get("-leggingsMiddle");
        reverseLeggingsRight = modelMap.get("-leggingsRight");
        reverseBootsLeft = modelMap.get("-bootsLeft");
        reverseBootsRight = modelMap.get("-bootsRight");
        reverseHelmet2 = modelMap.get("_helmet");
        reverseChestPlate2 = modelMap.get("_chestPlate");
        reverseChestPlateLeft2 = modelMap.get("_chestPlateLeft");
        reverseChestPlateMiddle2 = modelMap.get("_chestPlateMiddle");
        reverseChestPlateRight2 = modelMap.get("_chestPlateRight");
        reverseLeggings2 = modelMap.get("_leggings");
        reverseLeggingsLeft2 = modelMap.get("_leggingsLeft");
        reverseLeggingsMiddle2 = modelMap.get("_leggingsMiddle");
        reverseLeggingsRight2 = modelMap.get("_leggingsRight");
        reverseBootsLeft2 = modelMap.get("_bootsLeft");
        reverseBootsRight2 = modelMap.get("_bootsRight");
        ahoge = modelMap.get("ahoge");

        headAnimation(head, netHeadYaw, headPitch);
        blinkAnimation(blink, ageInTicks);
        tailAnimation(tail, ageInTicks);
        floatAnimation(sinFloat, cosFloat, negativeSinFloat, negativeCosFloat, negativeSinFloat2, negativeCosFloat2, ageInTicks);
        renderArmor(maid, helmet, chestPlate, chestPlateLeft, chestPlateMiddle, chestPlateRight,
            leggings, leggingsLeft, leggingsMiddle, leggingsRight, bootsLeft, bootsRight);
        renderReverseArmor(maid, reverseHelmet, reverseChestPlate, reverseChestPlateLeft, reverseChestPlateMiddle, reverseChestPlateRight,
            reverseLeggings, reverseLeggingsLeft, reverseLeggingsMiddle, reverseLeggingsRight,
            reverseBootsLeft, reverseBootsRight);
        renderReverseArmor(maid, reverseHelmet2, reverseChestPlate2, reverseChestPlateLeft2, reverseChestPlateMiddle2, reverseChestPlateRight2,
            reverseLeggings2, reverseLeggingsLeft2, reverseLeggingsMiddle2, reverseLeggingsRight2,
            reverseBootsLeft2, reverseBootsRight2);
        beggingPosture(maid, head, ahoge, ageInTicks);
    }
})

function headAnimation(head, netHeadYaw, headPitch) {
    if (head != undefined) {
        head.setRotateAngleX(headPitch * 0.017453292);
        head.setRotateAngleY(netHeadYaw * 0.017453292);
    }
}

function wingAnimation(wingLeft, wingRight, ageInTicks) {
    if (wingLeft != undefined) {
        wingLeft.setRotateAngleY(-Math.cos(ageInTicks * 0.3) * 0.2 + 1.0);
    }
    if (wingRight != undefined) {
        wingRight.setRotateAngleY(Math.cos(ageInTicks * 0.3) * 0.2 - 1.0);
    }
}

function blinkAnimation(blink, ageInTicks) {
    if (blink != undefined) {
        remainder = ageInTicks % 60;
        blink.setHidden(!(55 < remainder && remainder < 60));
    }
}

function tailAnimation(tail, ageInTicks) {
    if (tail != undefined) {
        tail.setRotateAngleX(Math.sin(ageInTicks * 0.2) * 0.05);
        tail.setRotateAngleZ(Math.cos(ageInTicks * 0.2) * 0.1);
    }
}

function floatAnimation(sinFloat, cosFloat, negativeSinFloat, negativeCosFloat, negativeSinFloat2, negativeCosFloat2, ageInTicks) {
    if (sinFloat != undefined) {
        sinFloat.setOffsetY(Math.sin(ageInTicks * 0.1) * 0.05);
    }
    if (cosFloat != undefined) {
        cosFloat.setOffsetY(Math.cos(ageInTicks * 0.1) * 0.05);
    }
    if (negativeSinFloat != undefined) {
        negativeSinFloat.setOffsetY(-Math.sin(ageInTicks * 0.1) * 0.05);
    }
    if (negativeSinFloat2 != undefined) {
        negativeSinFloat2.setOffsetY(-Math.sin(ageInTicks * 0.1) * 0.05);
    }
    if (negativeCosFloat != undefined) {
        negativeCosFloat.setOffsetY(-Math.cos(ageInTicks * 0.1) * 0.05);
    }
    if (negativeCosFloat2 != undefined) {
        negativeCosFloat2.setOffsetY(-Math.cos(ageInTicks * 0.1) * 0.05);
    }
}

function renderArmor(maid, helmet, chestPlate, chestPlateLeft, chestPlateMiddle, chestPlateRight, leggings, leggingsLeft, leggingsMiddle, leggingsRight, bootsLeft, bootsRight) {
    if (helmet != undefined) {
        helmet.setHidden(!maid.hasHelmet());
    }
    if (chestPlate != undefined) {
        chestPlate.setHidden(!maid.hasChestPlate());
    }
    if (chestPlateLeft != undefined) {
        chestPlateLeft.setHidden(!maid.hasChestPlate());
    }
    if (chestPlateMiddle != undefined) {
        chestPlateMiddle.setHidden(!maid.hasChestPlate());
    }
    if (chestPlateRight != undefined) {
        chestPlateRight.setHidden(!maid.hasChestPlate());
    }
    if (leggings != undefined) {
        leggings.setHidden(!maid.hasLeggings());
    }
    if (leggingsLeft != undefined) {
        leggingsLeft.setHidden(!maid.hasLeggings());
    }
    if (leggingsMiddle != undefined) {
        leggingsMiddle.setHidden(!maid.hasLeggings());
    }
    if (leggingsRight != undefined) {
        leggingsRight.setHidden(!maid.hasLeggings());
    }
    if (bootsLeft != undefined) {
        bootsLeft.setHidden(!maid.hasBoots());
    }
    if (bootsRight != undefined) {
        bootsRight.setHidden(!maid.hasBoots());
    }
}

function renderReverseArmor(maid, reverseHelmet, reverseChestPlate, reverseChestPlateLeft, reverseChestPlateMiddle, reverseChestPlateRight,
    reverseLeggings, reverseLeggingsLeft, reverseLeggingsMiddle, reverseLeggingsRight,
    reverseBootsLeft, reverseBootsRight) {

    if (reverseHelmet != undefined) {
        reverseHelmet.setHidden(maid.hasHelmet());
    }
    if (reverseChestPlate != undefined) {
        reverseChestPlate.setHidden(maid.hasChestPlate());
    }
    if (reverseChestPlateLeft != undefined) {
        reverseChestPlateLeft.setHidden(maid.hasChestPlate());
    }
    if (reverseChestPlateMiddle != undefined) {
        reverseChestPlateMiddle.setHidden(maid.hasChestPlate());
    }
    if (reverseChestPlateRight != undefined) {
        reverseChestPlateRight.setHidden(maid.hasChestPlate());
    }
    if (reverseLeggings != undefined) {
        reverseLeggings.setHidden(maid.hasLeggings());
    }
    if (reverseLeggingsLeft != undefined) {
        reverseLeggingsLeft.setHidden(maid.hasLeggings());
    }
    if (reverseLeggingsMiddle != undefined) {
        reverseLeggingsMiddle.setHidden(maid.hasLeggings());
    }
    if (reverseLeggingsRight != undefined) {
        reverseLeggingsRight.setHidden(maid.hasLeggings());
    }
    if (reverseBootsLeft != undefined) {
        reverseBootsLeft.setHidden(maid.hasBoots());
    }
    if (reverseBootsRight != undefined) {
        reverseBootsRight.setHidden(maid.hasBoots());
    }
}

function beggingPosture(maid, head, ahoge, ageInTicks) {
    if (maid.isBegging()) {
        if (head != undefined) {
            head.setRotateAngleZ(0.139);
        }
        if (ahoge != undefined) {
            ahoge.setRotateAngleX(Math.cos(ageInTicks * 1.0) * 0.05);
            ahoge.setRotateAngleZ(Math.sin(ageInTicks * 1.0) * 0.05);
        }
    } else {
        if (head != undefined) {
            head.setRotateAngleZ(0);
        }
        if (ahoge != undefined) {
            ahoge.setRotateAngleZ(0);
        }
    }
}