var GlWrapper = Java.type("com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper");

Java.asJSONCompatible({
	animation: function (maid, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, modelMap) {
		fan = modelMap.get("fan");
		spine1 = modelMap.get("spine1");
		spine2 = modelMap.get("spine2");
		spine3 = modelMap.get("spine3");
		spine4 = modelMap.get("spine4");
		spine5 = modelMap.get("spine5");
		spine6 = modelMap.get("spine6");
		hair2 = modelMap.get("hair2");
		hair3 = modelMap.get("hair3");
		drone = modelMap.get("drone");

		rotate = (ageInTicks % 360) * 0.5 + limbSwing;
		float = Math.sin(ageInTicks * 0.08) * 0.03;
		swing = Math.sin(limbSwingAmount * 0.2) + float;
		hairSwing = Math.sin(limbSwingAmount * 0.2) + Math.sin(ageInTicks * 0.04) * 0.03;
		hairSwingWalk = Math.sin(limbSwingAmount * 0.2) + Math.sin(ageInTicks * 0.3) * 0.03;

		if (maid.isSitting()) {
			GlWrapper.translate(0, 1.2, 0.5);
			GlWrapper.rotate(-90, 1, 0, 0);
		} else {
			GlWrapper.rotate(limbSwingAmount * 16, 1, 0, 0)
			if (drone != undefined) {drone.setOffsetY(float)}

			if (spine1 != undefined) {spine1.setRotateAngleX(swing)}
			if (spine2 != undefined) {spine2.setRotateAngleX(swing)}
			if (spine3 != undefined) {spine3.setRotateAngleX(swing)}
			if (spine4 != undefined) {spine4.setRotateAngleX(swing)}
			if (spine5 != undefined) {spine5.setRotateAngleX(swing)}
			if (spine6 != undefined) {spine6.setRotateAngleX(swing)}
			
			if (fan != undefined) {fan.setRotateAngleY(rotate)}
			if (hair2 != undefined) {hair2.setRotateAngleX(hairSwing)}
			if (hair3 != undefined) {hair3.setRotateAngleX(hairSwing)}
		}
	}
})